#include "q3la.h"

resultdata::resultdata(configdata* in_config)
{
	config = in_config;
}	

resultdata::~resultdata()
{
}

void resultdata::init() {
	player_count = 0;
	game_starttime = 0;
	mapname[0] = 0;
	timelimit = 0;
	fraglimit = 0;
	for (int i = 0; i < MAX_CLIENTS; i++) {
		for (int j = 0; j < MAX_CLIENTS; j++) {
			for (int k = 0; k < MAX_WEAPONS; k++) {
				kills[i][j][k] = 0;
			}
		}
		mkiol_temp[i] = 0;
		mkiol_time[i] = 0;
	}
}

int resultdata::add_player()
{
	players[player_count].init();
	player_count++;

	return (player_count-1);
}

int resultdata::add_kill(int killer, int victim, int weapon, int time)
{
	// return 1 - no kill added because of option no_bots
	// return 2 - victim or killer id > player_count

	if (config->no_bots == true) {
		if (players[client[killer].player_id].bot == true) return 1;
		if (players[client[victim].player_id].bot == true) return 1;
	}

	if ((client[victim].player_id > player_count-1) || (client[killer].player_id > player_count-1)) {
		return 2;
	}
	
	// Translate splash to weapon itself
	
	switch (weapon) {
	case 5:
	case 7:
	case 9:
	case 13:
		weapon--;
		break;
	default:
		break;
	}

	// Check for MAX_WEAPONS overflow

	if (weapon >= MAX_WEAPONS) {
		error::msg_and_exit ("resultdata::add_kill - weapon id > MAX_WEAPONS");
	}

	// Kill

	if ((victim <= player_count) && (killer <= player_count)) {
		
		if (killer != victim) {

			// Normal kill
			
			players[client[victim].player_id].killed[weapon]++;
			players[client[victim].player_id].killed[0]++; // add to "kills by all weapons"

			players[client[killer].player_id].kills[weapon]++;
			players[client[killer].player_id].kills[0]++; // add to "kills by all weapons"
			mkiol_temp[client[killer].player_id]++;

		} else {
			
			// Suicide
			
			players[client[victim].player_id].suicides[weapon]++;
			players[client[victim].player_id].suicides[0]++; // add to "kills by all weapons"
		}

		if (mkiol_temp[client[victim].player_id] > players[client[victim].player_id].mkiol) {
			players[client[victim].player_id].mkiol = mkiol_temp[client[victim].player_id];
			players[client[victim].player_id].mkiol_time = time - mkiol_time[client[victim].player_id];
		}
		mkiol_temp[client[victim].player_id] = 0;
		mkiol_time[client[victim].player_id] = time;
	}

	// Death

	if ((victim <= player_count) && (killer > player_count)) {
		players[client[victim].player_id].deaths++;
	}

	// Log kills in matrix (static method)

	if ((killer <= player_count) && (victim <= player_count)) {
		kills[client[killer].player_id][client[victim].player_id][weapon]++;
		kills[client[killer].player_id][client[victim].player_id][0]++; // add to "kills by all weapons"
	}

	return 0;
}

int resultdata::client_connect(int client_id, int connect_time)
{
	client[client_id].player_id = add_player ();
	client[client_id].connect_time = connect_time;
	mkiol_time[client_id] = connect_time;
	return 0;	
}

int resultdata::client_disconnect(int client_id, int disconnect_time)
{
	if (client[client_id].player_id == -1) {
		return 1;
	}
	players[client[client_id].player_id].playtime += disconnect_time - client[client_id].connect_time;
	if (disconnect_time - mkiol_time[client[client_id].player_id] > players[client[client_id].player_id].mkiol_time) {
		players[client[client_id].player_id].mkiol_time = disconnect_time - mkiol_time[client[client_id].player_id];
	}
	return 0;	
}

int resultdata::client_info(int client_id, char *name, bool bot)
{
	if (client[client_id].player_id == -1) {
		return 1;
	}
	strcpy (players[client[client_id].player_id].name, name);
	players[client[client_id].player_id].bot = bot;
	return 0;
}

int resultdata::get_player_count()
{
	return player_count;
}

player_t* resultdata::get_player(int player_id)
{
	return &players[player_id];
}

int resultdata::event_startofgame(int time)
{
	for (int i = 0; i < MAX_CLIENTS; i++) {
		client[i].player_id = -1;
	}
	game_starttime = time;
	return 0;
}

int resultdata::event_endofgame(int time)
{
	for (int i = 0; i < MAX_CLIENTS; i++) {
		if (client[i].player_id > -1) {
			if (i > get_player_count()) break; // shouldn't happen
			players[client[i].player_id].playtime += time - client[i].connect_time;
			if (time - mkiol_time[client[i].player_id] > players[client[i].player_id].mkiol_time) {
				players[client[i].player_id].mkiol_time = time - mkiol_time[client[i].player_id];
			}
		}
	}
	return 0;
}

unsigned short resultdata::get_kills(int player, int victim)
{
	unsigned int total = 0;
	for (int i = 0; i < MAX_WEAPONS; i++) {
		total += kills[player][victim][i];
	}
	return total;
}

unsigned short resultdata::get_kills(int player, int victim, int weapon)
{
	return kills[player][victim][weapon];
}

int resultdata::sort_players(sort_t order)
{
	for (int p1 = 0; p1 < get_player_count()-1; p1++) {
		for (int p2 = p1+1; p2 < get_player_count(); p2++) {
			double val1 = 0;
			double val2 = 0;
			player_t player1 = *(get_player(p1));
			player_t player2 = *(get_player(p2));
			switch (order) {
			case so_name:
				break;
			case so_kills:
				val1 = player1.get_kills();
				val2 = player2.get_kills();
				break;
			case so_frags:
				val1 = player1.get_kills() - player1.deaths - player1.get_suicides();
				val2 = player2.get_kills() - player2.deaths - player2.get_suicides();
				break;
			case so_skill: 
				val1 = player1.get_skill();
				val2 = player2.get_skill();
				break;
			}
			switch (order) {
			case so_name:
				break;
			case so_kills:
			case so_frags:
			case so_skill:
				if (val1 < val2) {
					make_sort(p1, p2);
				}
				break;
			}
		}
	}
	return 0;
}

int resultdata::make_sort(int p1, int p2)
{
	player_t temp_player = players[p1];
	players[p1] = players[p2];
	players[p2] = temp_player;
	int i;
	// sort kill matrix
	for (i = 0; i < get_player_count(); i++) {
		// vertical swap
		for (int j = 0; j < MAX_WEAPONS; j++) {
			unsigned short temp = kills[i][p1][j];
			kills[i][p1][j] = kills[i][p2][j];
			kills[i][p2][j] = temp;
		}
	}
	for (i = 0; i < get_player_count(); i++) {
		// horizontal swap
		for (int j = 0; j < MAX_WEAPONS; j++) {
			unsigned short temp = kills[p1][i][j];
			kills[p1][i][j] = kills[p2][i][j];
			kills[p2][i][j] = temp;
		}
	}
	return 0;
}

unsigned int resultdata::get_player_kills(int player)
{
	unsigned int total = 0;
	for (int i = 0; i < MAX_WEAPONS; i++) {
		total += get_player_kills (player, i);
	}
	return total;
}

unsigned int resultdata::get_player_kills(int player, int weapon)
{
	return players[player].kills[weapon];
}

unsigned int resultdata::get_player_killed(int player)
{
	unsigned int total = 0;
	for (int i = 0; i < MAX_WEAPONS; i++) {
		total += get_player_killed (player, i);
	}
	return total;
}

unsigned int resultdata::get_player_killed(int player, int weapon)
{
	return players[player].killed[weapon];
}

unsigned int resultdata::get_player_suicides(int player)
{
	unsigned int total = 0;
	for (int i = 0; i < MAX_WEAPONS; i++) {
		total += get_player_suicides (player, i);
	}
	return total;
}

unsigned int resultdata::get_player_suicides(int player, int weapon)
{
	return players[player].suicides[weapon];
}


unsigned int resultdata::get_total_kills()
{
	unsigned int total = 0;
	for (int i = 0; i < player_count; i++) {
		total += get_player_kills(i);
	}
	return total;
}

unsigned int resultdata::get_total_kills(int weapon)
{
	unsigned int total = 0;
	for (int i = 0; i < player_count; i++) {
		total += get_player_kills(i, weapon);
	}
	return total;
}

void resultdata::delete_bots()
{
	if (config->no_bots == false) { // only delete bots if no_bots option set
		return;
	}

	int new_count = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].bot == false) {
			players[new_count] = players[i];
			for (int j = 0; j < player_count; j++) {
				for (int w = 0; w < MAX_WEAPONS; w++) {
					kills[new_count][j][w] = kills[i][j][w];
					kills[j][new_count][w] = kills[j][i][w];
				}
			}
			new_count++;
		}
	}
	player_count = new_count;
}
